#ifndef __circular_buffer_h
#define __circular_buffer_h

#include "maindefs.h"
#include "xbee.h"

#define BUFFER_OK       0
#define BUFFER_ERROR    -1

#ifdef _BASE_STATION
#define BUFFER_SIZE     30
#else
#define BUFFER_SIZE     30 //(max is 125 for some reason)
#endif

typedef struct __BUFFER_DATA {
    unsigned int index_read;
    unsigned int index_write;
    unsigned int stored_length;
    unsigned char *buffer;
} BUFFER_DATA; // 7 bytes overhead

void buffer_init(BUFFER_DATA *);
char buffer_insert_one(unsigned char);
char buffer_insert(unsigned char length, unsigned char *msg);
char buffer_read(unsigned char length, unsigned char *dest);
unsigned int buffer_free_space(void);

#endif